-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

-- delete from et_format_object;
-- select * from et_format_object;
-- add default settings for admin instances 
 insert into et_format_object (catalog_id, instance_name, ind_active, pagesize, form_width, ind_rownumbers, ind_advanced_search, ind_multiselect) 
 values 
 (0, '*ADMIN',  1,-1,'600',1,0,0),
 (0, '*DEFAULT',1,20,'600',1,0,0)
 as loadval
 on DUPLICATE KEY UPDATE
   ind_active = loadval.ind_active,
   pagesize = loadval.pagesize,
   form_width = loadval.form_width,
   ind_rownumbers = loadval.ind_rownumbers,
   ind_advanced_search = loadval.ind_advanced_search,
   ind_multiselect = loadval.ind_multiselect
 ;
 
 delete from et_format_object where catalog_id < 0;
-- select * from et_format_object where catalog_id < 0;
 insert into et_format_object  (catalog_id, instance_name, ind_active, grid_caption_ui, grid_caption_suffix_ui, pagesize, form_width, ind_rownumbers, ind_advanced_search, ind_multiselect)  
 select
 loadval.catalog_id,
 loadval.instance_name,
 loadval.ind_active,
 loadval.grid_caption_ui,
  loadval.grid_caption_suffix_ui,
 loadval.pagesize,
 loadval.form_width,
 loadval.ind_rownumbers,
 loadval.ind_advanced_search,
 loadval.ind_multiselect  
 from  (
  select
 mdo.catalog_id,
 myvals.*
 from 
 (
 select
 column_0 as object,
 column_1 as instance_name, 
 column_2 as ind_active, 
 column_3 as grid_caption_ui, 
 column_4 as grid_caption_suffix_ui, 
 column_5 as pagesize, 
 column_6 as form_width, 
 column_7 as ind_rownumbers, 
 column_8 as ind_advanced_search,
 column_9 as ind_multiselect
 from
(
values
ROW ('et_callable_access',		 		'*ADMIN_EDIT_MDD', 	 	1, null, 'edit detail', 	null, null, null, null, null),
ROW ('et_callable_object',	 			'*ADMIN_EDIT_MDM',		1, null, 'edit', 			10, '1200', null, 1, null),
ROW ('et_callable_object',	 			'*ADMIN_LIST',			1, null, 'list', 			10, '1200', null, 1, null),

ROW ('et_callable_seq',	 				'*ADMIN_EDIT_MDD',		1, null, 'edit detail', 	10, '1200', null, 1, null),

ROW ('et_catalog_object',	 			'*ADMIN_EDIT', 			1, null, 'edit', 	10, '1200', null, 1, null),
ROW ('et_catalog_object',	 			'*ADMIN_EDIT', 		 	1, null, 'edit', 	10, '1200', null, 1, null),
ROW ('et_catalog_object', 				'*ADMIN_LIST', 		 	1, null, 'list'	, 10, '900', null, 1, null),
ROW ('et_catalog_object', 				'*ADMIN_EDIT_ADD', 	 	1, null, 'add only', 10, '900', null, 1, null),
ROW ('et_catalog_object', 				'*ADMIN_EDIT_ADD2', 	1, null, 'add only - manual override', 10, '900', null, 1, null),

ROW ('et_catalog_object_access', 		'*ADMIN_EDIT_MDD', 	 	1, null, 'edit', 	null, null, null, null, null),
ROW ('et_catalog_object_access', 		'*ADMIN_LIST_MDD',		1, null, 'list', 	null, null, null, null, null),

ROW ('et_catalog_object_callable', 		'*ADMIN_EDIT_MDD', 	 	1, null, 'edit', 	null, null, null, null, null),

ROW ('et_catalog_object_column_prop', 	'*ADMIN_EDIT_MDD',   	1, null, 'edit', 	null, '1100', null, null, null),
ROW ('et_catalog_object_column_prop', 	'*ADMIN_EDIT_MDD2',   	1, null, 'edit - UI properties ', 	null, '1100', null, null, null),

ROW ('et_catalog_object_instance',		'*ADMIN_LIST', 			1, null, 'list', 	null, null, null, null, null),
ROW ('et_catalog_object_instance', 		'*ADMIN_EDIT_MDD', 		1, null, 'edit detail', 	null, '1100', null, null, null),

ROW ('et_connection',		 			'*ADMIN_EDIT',		 	1, null, 'edit', 	null, null, null, null, null),
ROW ('et_constraint',		 			'*ADMIN_EDIT',		 	1, null, 'edit', 	null, null, null, null, null),

ROW ('et_format_collection_column', 	'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
ROW ('et_format_domain_logical', 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
ROW ('et_format_domain_physical', 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
ROW ('et_format_domain_semantic', 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
ROW ('et_format_object', 				'*ADMIN_EDIT_MDD', 		1, null, 'edit', 	null, null, null, null, null),
ROW ('et_format_object_column', 		'*ADMIN_EDIT_MDD', 		1, null, 'edit', 	null, null, null, null, null),

ROW ('et_logging',			 			'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),
ROW ('et_lookup',			 			'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),

ROW ('et_metadb_object',				'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),

ROW ('et_table_link', 					'*ADMIN_EDIT_MDM2',		1, null, 'master detail - master config', null, null, null, null, null),
ROW ('et_table_link', 					'*ADMIN_EDIT_MDM3', 	1, null, 'advanced filter - data config', null, null, null, null, null),

ROW ('et_table_link_detail', 			'*ADMIN_EDIT_MDD2', 	1, null, 'master detail - detail config', null, null, null, null, null),
ROW ('et_table_link_detail', 			'*ADMIN_EDIT_MDD3', 	1, null, 'advanced filter - filtered by config', null, null, null, null, null),

ROW ('et_transaction', 					'*ADMIN_EDIT_MDM', 		1, null, 'edit', null, null, null, null, null),
ROW ('et_transaction', 					'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),

ROW ('et_transaction_access', 			'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, null, null, null, null),

ROW ('et_transaction_parameter_set',	'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, '900', null, 1, null),

ROW ('et_transaction_menu', 			'*ADMIN_EDIT_MDM2', 	1, null, 'node items', null, '900', null, 1, null),
ROW ('et_transaction_menu', 			'*ADMIN_EDIT_MDD2', 	1, null, 'leaf items', null, '900', null, 1, null),

ROW ('et_user', 						'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('et_user', 						'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),

ROW ('et_user_comm_area', 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),


ROW ('et_user_group', 					'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('et_user_group', 					'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),

ROW ('et_user_group_member', 			'*ADMIN_EDIT_MDD', 		1, null, 'edit details', null, null, null, null, null),

ROW ('et_transaction_menu', 			'*ADMIN_EDIT_MDD2', 	1, null, 'nodes', null, '900', null, 1, null),

ROW ('etx_message_text', 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('etx_message_text', 				'*ADMIN_EDIT_CUST', 	1, null, 'edit customer text', null, null, null, null, null),

ROW ('etx_sequence', 					'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('etx_sequence', 					'*ADMIN_EDIT_CUST', 	1, null, 'edit customer sequence', null, null, null, null, null),

ROW ('etx_user_config', 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('etx_user_config', 				'*ADMIN_EDIT_CUST', 	1, null, 'edit customer config', null, null, null, null, null),

ROW ('etx_system_config', 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
ROW ('etx_system_config', 				'*ADMIN_EDIT_CUST',		1, null, 'edit customer config', null, null, null, null, null),
ROW ('etx_catalog_object_config', 		'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, null, null, null, null)
) allvals
) myvals
join et_metadb_object mdo
  on mdo.object = myvals.object
) loadval
on DUPLICATE KEY UPDATE
   ind_active = loadval.ind_active,
   grid_caption_ui = loadval.grid_caption_ui,
   pagesize = loadval.pagesize,
   form_width = loadval.form_width,
   ind_rownumbers = loadval.ind_rownumbers,
   ind_advanced_search = loadval.ind_advanced_search,
   ind_multiselect = loadval.ind_multiselect
 ;
 